#ifndef _MAINTEXTEDIT_H
#define _MAINTEXTEDIT_H

#include <QtGui>

class QTextEdit;
class QHBoxLayout;
class TextEdit;
class NumberLine;

class MainTextEdit : public QFrame
{
    Q_OBJECT
public:
	MainTextEdit( QWidget *parent = 0 );
	~MainTextEdit();
	
	TextEdit* GetTextEdit() const { return this->textEdit; }
	NumberLine* GetNumberLine() const { return this->numbers; }
	
	// Breakpoint
	void setCurrentLine( int lineno );
	
	// Cursor Info
	int currentCursorline();
	
	void textChanged( int pos, int removed, int added );

public slots:
	void slot_setBreakpoint();
	void slot_Allbreakpointclear();
	void setBreakpoint();
	void Allbreakpointclear();
	void breakpointclear();
	
protected:
	//ContextMenuEvent
	//virtual void contextMenuEvent( QContextMenuEvent *);
	
private:
	int cursorLine;

	QHBoxLayout *box;
	TextEdit *textEdit;
	NumberLine* numbers;
	int m_currentLine;
	QTextCursor highlight;
};

#endif //_MAINTEXTEDIT_H
